#include "digirule1.h"

///////////////////////////////////////////////////////////////////////////////
// private data

static const bool_t lut[256] =
{
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 
};

static uint16 time, timer;

static enum
{
	StateGroup1,
	StateGroup2,
	StateGroup3,
	StateGroup4,
	StateGroup5,
	StateWait,
} state;

///////////////////////////////////////////////////////////////////////////////
// public functions

void mode_sparkle_init( void )
{
	all_leds_set( 0 );
	time = 32;
	timer = 0;
	state = StateGroup1;
}

void mode_sparkle_process( void )
{
	if( button.down.pressed )
	{
		if( time != 256 )
		{
			time <<= 1;
			timer = 0;
		}
	}
	else if( button.up.pressed )
	{
		if( time != 4 )
		{
			time >>= 1;
			timer = 0;
		}
	}
	else
	{
		switch( state )
		{
			case StateGroup1:
				A_LED    = lut[prng()];
				B_LED    = lut[prng()];
				NOT_LED  = lut[prng()];
				OR_LED   = lut[prng()];
				AND_LED  = lut[prng()];
				state++;
				break;

			case StateGroup2:
				XOR_LED  = lut[prng()];
				NOR_LED  = lut[prng()];
				NAND_LED = lut[prng()];
				XNOR_LED = lut[prng()];
				X_LED    = lut[prng()];
				state++;
				break;

			case StateGroup3:
				SJTD_LED = lut[prng()];
				CLK_LED  = lut[prng()];
				RK_LED   = lut[prng()];
				SR_LED   = lut[prng()];
				JK_LED   = lut[prng()];
				state++;
				break;

			case StateGroup4:
				T_LED    = lut[prng()];
				D_LED    = lut[prng()];
				Q_LED    = lut[prng()];
				QNOT_LED = lut[prng()];
				CTR8_LED = lut[prng()];
				state++;
				break;

			case StateGroup5:
				CTR4_LED = lut[prng()];
				CTR2_LED = lut[prng()];
				CTR1_LED = lut[prng()];
				timer = 0;
				state++;
				break;

			case StateWait:
				if( ++timer == time )
					state = StateGroup1;

				break;
		}
	}
}
