#include "digirule1.h"

///////////////////////////////////////////////////////////////////////////////
// private data

static enum
{
	StateIdle,
	StateRolling,
} state;

static uint8 time, timer;

///////////////////////////////////////////////////////////////////////////////
// public functions

void mode_dice_init( void )
{
	all_leds_set( 0 );
	state = StateIdle;
}

void mode_dice_process( void )
{
	switch( state )
	{
		case StateIdle:
			if( button.b.pressed )		// roll
			{
				time = 1;
				timer = 0;
				state = StateRolling;
			}
			
			break;
			
		case StateRolling:
			if( ++timer == time )
			{
				ctr_leds_set( 1 + (prng() % 6) );		// display a random number in the range 1..6
				
				if( ++time == 50 )			// decrease speed
					state = StateIdle;
				else
					timer = 0;
			}
			
			break;
	}
}
