#include "digirule1.h"

///////////////////////////////////////////////////////////////////////////////
// private data

static const uint8 images[3][200] =
{
	{	// sine wave
		0b00000100, 0b00000100, 0b00000100, 0b00001000, 0b00001000, 0b00010000, 0b00010000, 0b00010000, 
		0b00010000, 0b00001000, 0b00001000, 0b00000100, 0b00000110, 0b00000010, 0b00000001, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000010, 0b00000100, 0b00001000, 
		0b00011000, 0b00110000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 0b00110000, 
		0b00011000, 0b00001100, 0b00000010, 0b00000010, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000010, 0b00000110, 0b00000100, 
		0b00001000, 0b00011000, 0b00110000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 
		0b00100000, 0b00100000, 0b00110000, 0b00011000, 0b00001100, 0b00000010, 0b00000011, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000011, 
		0b00000110, 0b00000100, 0b00001000, 0b00011000, 0b00110000, 0b00100000, 0b00100000, 0b00100000, 
		0b00100000, 0b00100000, 0b00110000, 0b00001000, 0b00000100, 0b00000010, 0b00000001, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000010, 
		0b00000110, 0b00001000, 0b00010000, 0b00110000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 
		0b00100000, 0b00010000, 0b00011000, 0b00001100, 0b00000110, 0b00000001, 0b00000001, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000010, 0b00000110, 
		0b00001000, 0b00011000, 0b00010000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 
		0b00100000, 0b00100000, 0b00010000, 0b00001000, 0b00001100, 0b00000110, 0b00000010, 0b00000010, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000011, 
		0b00000010, 0b00000100, 0b00001000, 0b00011000, 0b00010000, 0b00010000, 0b00010000, 0b00010000, 
		0b00010000, 0b00011000, 0b00001100, 0b00000100, 0b00000010, 0b00000001, 0b00000001, 0b00000001, 
		0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000010, 0b00000110, 0b00001000, 
		0b00010000, 0b00100000, 0b00100000, 0b00100000, 0b00100000, 0b00010000, 0b00011000, 0b00001000, 
		0b00000100, 0b00000010, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 0b00000001, 
		0b00000011, 0b00000110, 0b00001100, 0b00011000, 0b00010000, 0b00010000, 0b00010000, 0b00010000, 
		0b00010000, 0b00010000, 0b00011000, 0b00001100, 0b00000111, 0b00000001, 0b00000000, 0b00000000, 
	},
	{	// "The Digirule Rules!"
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00110000, 0b00100001, 0b00111111, 0b00111111, 
		0b00100001, 0b00110000, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00001000, 0b00111111, 
		0b00111111, 0b00100001, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00101001, 0b00101001, 
		0b00110011, 0b00000000, 0b00000000, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00100001, 
		0b00100001, 0b00111111, 0b00011110, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00100001, 
		0b00000000, 0b00011110, 0b00111111, 0b00100001, 0b00100111, 0b00110111, 0b00000100, 0b00000000, 
		0b00100001, 0b00111111, 0b00111111, 0b00100001, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 
		0b00100100, 0b00111111, 0b00011011, 0b00000001, 0b00100000, 0b00111110, 0b00111111, 0b00000001, 
		0b00100001, 0b00111110, 0b00100000, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00100001, 
		0b00000011, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00101001, 0b00101001, 0b00110011, 
		0b00000000, 0b00000000, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00100100, 0b00111111, 
		0b00011011, 0b00000001, 0b00100000, 0b00111110, 0b00111111, 0b00000001, 0b00100001, 0b00111110, 
		0b00100000, 0b00000000, 0b00100001, 0b00111111, 0b00111111, 0b00100001, 0b00000011, 0b00000000, 
		0b00100001, 0b00111111, 0b00111111, 0b00101001, 0b00101001, 0b00110011, 0b00000000, 0b00011001, 
		0b00111101, 0b00101101, 0b00101111, 0b00100110, 0b00000000, 0b00111101, 0b00111101, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
	},
	{	// smiley faces
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000, 
		0b00111110, 0b01000001, 0b01101001, 0b01000101, 0b01000101, 0b01101001, 0b01000001, 0b00111110, 
		0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00111110, 0b01000001, 0b01101001, 0b01000101, 
		0b01000101, 0b01101001, 0b01000001, 0b00111110, 0b00000000, 0b00000000, 0b00000000, 0b00000000,
	},
};

static uint8 image, column;

///////////////////////////////////////////////////////////////////////////////
// public functions

void mode_pov_init( void )
{
	all_leds_set( 0 );
	image = column = 0;
}

void mode_pov_process( void )
{
	union8_t data;
	
	data.byte = images[image][column];
	NOT_LED  = data.bit6;
	OR_LED   = data.bit5;
	AND_LED  = data.bit4;
	XOR_LED  = data.bit3;
	NOR_LED  = data.bit2;
	NAND_LED = data.bit1;
	XNOR_LED = data.bit0;

	if( ++column == 200 )
		column = 0;
	
	if( button.b.pressed )		// select next image
		if( ++image == 3 )
			image = 0;
}
